function LiveFitKernel(src,~,fig,handles,Spec,Energies,FWHM)
FitDispOpt = get(handles.FitDispOpt,'Value');
DiffMult   = str2double(get(handles.DiffMult,'String'));
Width      = str2double(get(handles.Width,'String'));
DecMeth    = get(handles.DecMeth,'Value');
pos        = src.Position;
Ind1       = pos(1);
Ind2       = pos(1)+pos(3);

index1    = find(Energies<=Ind1,1,'last');
index2    = find(Energies>=Ind2,1,'first');


switch FitDispOpt
    case 1
        Spec  = reshape(Spec,[size(Spec,1).*size(Spec,2),size(Spec,3)]);
        Spec  = mean(Spec,1);
        Spec  = Spec/max(Spec,[],2);
    case 2
        Spec  = mean(Spec,2);
        Spec  = reshape(Spec,[size(Spec,1),size(Spec,3)]);
        Spec  = Spec./max(Spec,[],2);
    case 3
        Spec  = reshape(Spec,[size(Spec,1).*size(Spec,2),size(Spec,3)]);
        Spec  = Spec./max(Spec,[],2);
end
Peak      = mean(Spec(:,index1:index2),1);
E         = Energies(index1:index2);
FWHM      = mean(FWHM,'all');
Sigma     = mean(FWHM,'all')./(2.*sqrt(2*log(2)));
options   = optimset('Display','off');

switch DecMeth
    case 1
        %% Fowler-Nordheim
        x      = [ 1 , 0 , 1, 0.5 ];
        eqn         = @(x) sum((x(1).*exp(-(E-real(x(2)))./x(3))./(1+exp(-(E-real(x(2)))./x(4))) - Peak).^2);
        x           = fminsearch(eqn,x,options);
        Fit         = x(1).*exp(-(Energies-real(x(2)))./x(3))./(1+exp(-(Energies-real(x(2)))./x(4)));
    case 2
        %% Gauss
        x           = [ 1 , 0 , Sigma];
        eqn         = @(x) sum((x(1).*exp(-((E-x(2))./(sqrt(2).*x(3))).^2)- Peak).^2);
        x           = fminsearch(eqn,x,options);
        Fit     = x(1).*exp(-((Energies-x(2))./(sqrt(2).*x(3))).^2);
    case 3
        %% Weibull
        x           =  [0.00044883, 1.7517 , -1.8317 ,14.204 ,  3.2323e-06];
        eqn         = @(x) sum(( x(1) .* ((E-x(2))./x(3)).^(x(4)-1).* exp(((E-x(2))./x(3)).^x(4))+x(5) - Peak).^2);
        x           = fminsearch(eqn,x,options);
        Fit    =  x(1) .* ((Energies-x(2))./x(3)).^(x(4)-1).* exp(((Energies-x(2))./x(3)).^x(4));
    case 7
        %% Dual ZLP
        ZLP_load  = get(handles.LoadPeak,'UserData');
        ZLP_load1 = ZLP_load{1,1}(1,:);
        ZLP_load1 = ZLP_load1./sum(ZLP_load1,2);
        ZLP_load2 = ZLP_load{2,1}(1,:);
        ZLP_load2 = ZLP_load2./sum(ZLP_load2,2);
        
        ZLP_load1   = ZLP_load1./max(ZLP_load1,[],2);
        ZLP_load2   = ZLP_load2./max(ZLP_load2,[],2);
        
        ZLPfit1   = ZLP_load1(index1:index2);
        ZLPfit2   = ZLP_load2(index1:index2);
        x         = [0.5 , 0.5];
        eqn       = @(x) sum((abs(x(1)).*ZLPfit1+ abs(x(2)).*ZLPfit2-Peak).^2);
        x         = fminsearch(eqn,x,options);
        Fit       = abs(x(1)).*ZLP_load1 + abs(x(2)).*ZLP_load2;
    otherwise
        close(fig)
        msgbox('Fitting for selected method is useless, try again!');
        return

end

fit       = Fit./sum(Spec,2);
clearvars Fit
spec      = Spec./sum(Spec,2);
res       = (spec-fit)*DiffMult;
PosSpec   = res;
PosSpec(PosSpec<0)=0;
NegSpec   = res;
NegSpec(PosSpec>0)=0;
PosSpec   = mean(PosSpec,1);
NegSpec   = mean(NegSpec,1);
spec      = mean(spec,1);
fit       = mean(fit,1);

%% Plot
figure(fig)
hold on
h = findobj(gca,'type','line');
delete(h);

plot(Energies,spec,'Color','b');
hold on
plot(Energies,fit,'Color','m');
plot(Energies,PosSpec,'Color','g');
plot(Energies,NegSpec,'Color','r');
plot(Energies,zeros(size(Energies)),'--','Color','k');
legend('Normed mean Spectrum','Fit',['Pos. Difference x',num2str(DiffMult)],['Neg. Difference x',num2str(DiffMult)]);ylabel('mean Loss probability [a.u.]');
xlabel('Loss energy [eV]');


hold off

xlim([-mean(FWHM,'all')*Width/2,mean(FWHM,'all')*Width/2]);
ylim([-max(spec)/2,max(spec).*1.25])

end